package gov.va.med.mhv.usermgmt.service;

import java.util.Collection;

import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTOLight;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.model.InPersonAuthentication;
import gov.va.med.mhv.common.data.model.InPersonAuthenticationLight;

public interface InPersonAuthenticationService {

	/**
	 * Execute the GetIPAPatientById operation
	 *
	 * @param patientId  
	 * @return InPersonAuthenticationServiceResponse
	 */
	void getIPAPatientById(Long patientId, ResponseUtil response);

	/**
	 * Execute the GetIPAPatientById operation
	 * 
	 * @param userProfileid
	 * @return InPersonAuthenticationServiceResponse
	 */
	void getIPAByuserProfileid(Long userProfileid, ResponseUtil response);

	/**
	 * Determines whether the user with the given user name is an in-person-authenticated (IPA-ed) patient. Return a Patient instance if the user is an IPAed
	 * patient; null otherwise.
	 * 
	 * @param userName
	 *            The name of the user to determine IPA status for.
	 * @return PatientServiceResponse
	 */
	void getIPAedPatientForUser(String userName, ResponseUtil response);

	/**
	 * Execute the DeferAuthentication operation
	 * 
	 * @param ipa
	 * @return InPersonAuthenticationServiceResponse
	 */
	void deferAuthentication(InPersonAuthenticationDTO ipa, ResponseUtil response);

	void deferAuthenticationLight(InPersonAuthenticationDTOLight ipa, ResponseUtil response);
	
	void authenticateOnline(InPersonAuthenticationDTOLight ipa, ResponseUtil response);
	
	/**
	 * Execute the TerminateAuthentication operation
	 * 
	 * @param ipa
	 * @return InPersonAuthenticationServiceResponse
	 */
	void terminateAuthentication(InPersonAuthenticationDTO ipa, ResponseUtil response);

	/**
	 * Execute the FindPatients operation
	 * 
	 * @param criteria
	 * @return PatientInformationCollectionServiceResponse
	 */
	// void findPatients(InPersonAuthenticationCriteria criteria, ResponseUtil response);

	/**
	 * Execute the AuthenticateMany operation
	 * 
	 * @param patientIds
	 * @return VoidServiceResponse
	 */
	void authenticateMany(Collection patientIds, ResponseUtil response);

	/**
	 * Execute the FinalizeAuthentication operation
	 * 
	 * @param ipa
	 * @param error
	 *            Not null if and only if an error occurred.
	 * @return InPersonAuthenticationServiceResponse
	 */
	void finalizeAuthentication(InPersonAuthenticationDTO ipa, String error, ResponseUtil response);

	/**
	 * Execute the GetAuthenticationForPatient operation
	 * 
	 * @param patientId
	 * @return InPersonAuthenticationServiceResponse
	 */
	void getAuthenticationForPatient(Long patientId, ResponseUtil response);

	/**
	 * Execute the Unauthenticate operation
	 * 
	 * @param ipa
	 * @return InPersonAuthenticationServiceResponse
	 */
	void unauthenticateWithAdminUserName(InPersonAuthentication ipa, String adminUserName, ResponseUtil response);
	
	/**
	 * Execute the Unauthenticate operation
	 * 
	 * @param ipa
	 * @return InPersonAuthenticationServiceResponse
	 */
	void mviUnauthenticate(InPersonAuthentication ipa, String adminUserName, ResponseUtil response);

	/**
	 * Execute the FinalizeUnauthentication operation
	 * 
	 * @param ipa
	 * @param error
	 *            Not null if and only if an error occurred.
	 * @return InPersonAuthenticationServiceResponse
	 */
	void finalizeUnauthentication(InPersonAuthenticationDTO ipa, String error, ResponseUtil response);

	/**
	 * Execute the SaveIPA operation
	 * 
	 * @param ipa
	 * @return VoidServiceResponse
	 */
	InPersonAuthentication saveIPA(InPersonAuthentication ipa);
	InPersonAuthentication saveInPersonAuthentication(InPersonAuthenticationDTO ipa);
	InPersonAuthenticationLight saveInPersonAuthenticationLight(InPersonAuthenticationDTOLight ipa);
	InPersonAuthenticationLight saveIPALight(InPersonAuthenticationLight ipa);

	/**
	 * Execute the ForceUnauthenticateUnCorrelate operation
	 * 
	 * @param ipa
	 * @return InPersonAuthenticationServiceResponse
	 */
	void forceUnauthenticateUnCorrelate(InPersonAuthenticationDTO ipa, ResponseUtil response);

	/**
	 * Execute the IsPatientAuthenticated operation
	 * 
	 * @param patientId
	 * @return BooleanServiceResponse
	 */
	void isPatientAuthenticated(Long patientId, ResponseUtil<Boolean> response);

	/**
	 * Execute the Authenticate operation
	 * 
	 * @param ipa
	 * @return InPersonAuthenticationServiceResponse
	 */
	void authenticateFull(InPersonAuthenticationDTOLight ipa, ResponseUtil<InPersonAuthenticationDTOLight> response);

	void authenticate(InPersonAuthenticationDTOLight ipa, ResponseUtil response);
}
